﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections;
using System.Drawing;
using System.Drawing.Printing;

using Inet.Viewer.WinForms;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// simple implementation of IPageView for printing
    /// </summary>
    internal class PrinterPageView : IPageReceiver
    {
        private ArrayList fontDataVersions = new ArrayList();
        private Action<Exception> errorDelegate;
        private PrintPageEventArgs printEvent;
        private int page;
        private PageInfo pageInfo;
        private ReportDataCache reportDataCache;

        /// <summary>
        /// simple constructor for creating a pageview for printing
        /// </summary>
        /// <param name="errorReceiver">For reporting errors to</param>
        /// <param name="reportDataCache">for fetching the report data for printing</param>
        /// <param name="ev">event args for printing</param>    
        internal PrinterPageView(Action<Exception> errorReceiver, ReportDataCache reportDataCache, PrintPageEventArgs ev)
        {
            this.errorDelegate = errorReceiver;
            this.printEvent = ev;
            this.reportDataCache = reportDataCache;
        }
 

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public int Page
        {
            get
            {
                return page;
            }
            set
            {
                page = value;
            }
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public bool WriteReportInfo(ReportInfo info, PageLoader loader)
        {
            return true;
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public bool WritePageInfo(PageInfo info, PageLoader loader)
        {
            this.pageInfo = info;
            int pageWidth = pageInfo.PageWidth + pageInfo.BorderLeft + pageInfo.BorderRight;
            int pageHeight = pageInfo.PageHeight + pageInfo.BorderTop + pageInfo.BorderBottom;

            printEvent.PageSettings.Margins = info.PrintMargins;
            Graphics2DPainter painter = loader.Painter;
            Graphics g = printEvent.Graphics;
            painter.Graphics = g;

            // calculate the scale factor 
            RectangleF bounds = g.VisibleClipBounds;
            float factorx = bounds.Width / pageWidth;
            float factory = bounds.Height / pageHeight;
            float factor = Math.Min(factorx, factory);
            painter.ZoomFactor = factor;
            return true;
        }

        public void PageLoadFailure(Exception exception)
        {
            errorDelegate(exception);
        }
        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public bool PromptDialogOpen
        {
            get { throw new NotImplementedException(); }
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public void PaintImage(bool refresh)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public System.Drawing.Font GetEmbeddedFont(int fontID, int fontRevision)
        {
            return reportDataCache.GetEmbeddedFont(fontID, fontRevision);
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public void ClearFontCache()
        {
            fontDataVersions.Clear();
        }

        /// <summary>
        /// <inheritdoc/>
        /// </summary>
        public Data.PageInfo PageInfo
        {
            get { return pageInfo; }
        }
    }
}
